﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.SceneManagement;
using UnityEngine.UI;

public class MenuController : MonoBehaviour
{
    public GameObject dialog;
    public GameObject background;
    public GameObject ghost;
    public GameObject pressSpaceToStartObject;
    public AudioSource menuSong;
    public AudioSource introSong;

    public float backgroundMoveSpeed = 1f;
    public float ghostMoveThreshold = .5f;
    public float ghostMoveSpeed = 1f;
    public float dialogThreshold = .5f;

    public Vector3 backgroundDestination = new Vector3(0f, 4.5f, 0f);

    protected string[] introDialogTexts =
    {
        "The year is 20XX, in a world not too unlike ours, a murder has occured.",
        "You wake up next to the scene, but something doesnt feel quite right, you cant feel your legs, arms, or anything for that matter.",
        "The body on the floor, it used to be yours. You had so much left to be done, or at least it feels like it, your memory is hazy." ,
        "You start moving somewhere, it's like you are being guided by something. You must remember!"
    };

    protected int dialogIdx = -1;

    // Start is called before the first frame update
    void Start()
    {
        
    }

    // Update is called once per frame
    void Update()
    {
        if (dialogIdx >= 0)
        {
            background.transform.position = Vector3.Lerp(background.transform.position, backgroundDestination, Time.deltaTime * ghostMoveSpeed);
        }

        if ((background.transform.position - backgroundDestination).magnitude <= ghostMoveThreshold)
        {
            ghost.transform.position = Vector3.Lerp(ghost.transform.position, Vector3.zero, Time.deltaTime * ghostMoveSpeed);
        }

        if (!dialog.activeSelf && ghost.transform.position.magnitude <= dialogThreshold)
        {
            dialog.SetActive(true);
        }

        if (Input.GetButtonDown("Interact") && (dialogIdx == -1 || dialog.activeSelf))
        {
            if (dialogIdx == -1)
            {
                pressSpaceToStartObject.SetActive(false);
                menuSong.Stop();
                introSong.Play();
            }

            ++dialogIdx;

            if (dialogIdx < introDialogTexts.Length)
            {
                dialog.transform.GetChild(0).GetComponent<Text>().text = introDialogTexts[dialogIdx];
            }
            else
            {
                SceneManager.LoadScene("GameScene1");
            }
        }
    }
}
